/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

#ifndef __REG_39_H__
#define __REG_39_H__
/* ***********************************************************************
   *                                                                     *
   * regx39.h                                                            *
   * Christoph Schmidt, BID R&D, 12. Sep. 1997                          *
   *                                                                     *
   * defines for second command byte and 16-bit commands                 *
   *                                                                     *
   ***********************************************************************
*/

#include "regxdir.h"

#define MERGE_OBSACTION_NOLOCK(cmd)	CMD_MERGE (CMDG_OBSACTION_NOLOCK, cmd)

/* accumulated error registers */

#define OUT_OBS_STATUS			 4
#define IN_OBS_STATUS			 0

#define CMDM_OBS_ACCU_READ		0x05
#define CMD_OBS_ACCU_READ		MERGE_OBSACTION_NOLOCK (CMDM_OBS_ACCU_READ)
#define IN_OBS_ACCU_READ		IN_OBS_STATUS
#define OUT_OBS_ACCU_READ		OUT_OBS_STATUS

#define CMDM_OBS_ACCU2_READ		0x06
#define CMD_OBS_ACCU2_READ		MERGE_OBSACTION_NOLOCK (CMDM_OBS_ACCU2_READ)
#define IN_OBS_ACCU2_READ		IN_OBS_STATUS
#define OUT_OBS_ACCU2_READ		OUT_OBS_STATUS

/* first error registers */
#define CMDM_OBS_FIRST_READ		0x07
#define CMD_OBS_FIRST_READ		MERGE_OBSACTION_NOLOCK (CMDM_OBS_FIRST_READ)
#define IN_OBS_FIRST_READ		IN_OBS_STATUS
#define OUT_OBS_FIRST_READ	 	OUT_OBS_STATUS

#define CMDM_OBS_FIRST2_READ		0x08
#define CMD_OBS_FIRST2_READ		MERGE_OBSACTION_NOLOCK (CMDM_OBS_FIRST2_READ)
#define IN_OBS_FIRST2_READ		IN_OBS_STATUS
#define OUT_OBS_FIRST2_READ	 	OUT_OBS_STATUS

/* status register */
#define CMDM_OBS_STATUS_READ		0x09
#define CMD_OBS_STATUS_READ		MERGE_OBSACTION_NOLOCK (CMDM_OBS_STATUS_READ)
#define IN_OBS_STATUS_READ		IN_OBS_STATUS
#define OUT_OBS_STATUS_READ	 	OUT_OBS_STATUS

#endif
